import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { School, Calendar, FileText, CreditCard, IdCard } from "lucide-react";

const SmartSchool = () => {
  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <School className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart School ERP</h1>
              <p className="text-muted-foreground">Complete school management system</p>
            </div>
          </div>

          <Tabs defaultValue="attendance">
            <TabsList>
              <TabsTrigger value="attendance">Attendance</TabsTrigger>
              <TabsTrigger value="routine">Routine</TabsTrigger>
              <TabsTrigger value="homework">Homework</TabsTrigger>
              <TabsTrigger value="exams">Exams</TabsTrigger>
              <TabsTrigger value="payment">Payment</TabsTrigger>
              <TabsTrigger value="idcard">ID Card</TabsTrigger>
            </TabsList>

            <TabsContent value="attendance" className="mt-6">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Calendar className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Attendance</h3>
                </div>
                <p className="text-muted-foreground mb-4">Track student attendance</p>
                <div className="grid grid-cols-7 gap-2">
                  {["S", "M", "T", "W", "T", "F", "S"].map((day, i) => (
                    <div key={i} className="p-2 border rounded text-center text-sm">
                      {day}
                    </div>
                  ))}
                </div>
              </Card>
            </TabsContent>

            <TabsContent value="routine">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">Class Routine</h3>
                <p className="text-muted-foreground">View daily class schedule</p>
              </Card>
            </TabsContent>

            <TabsContent value="homework">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <FileText className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Homework</h3>
                </div>
                <p className="text-muted-foreground">Manage homework assignments</p>
              </Card>
            </TabsContent>

            <TabsContent value="exams">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">Exam Schedule</h3>
                <p className="text-muted-foreground">Upcoming exams and results</p>
              </Card>
            </TabsContent>

            <TabsContent value="payment">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <CreditCard className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Fee Payment</h3>
                </div>
                <p className="text-muted-foreground mb-4">Manage school fee payments</p>
                <Button>View Payment History</Button>
              </Card>
            </TabsContent>

            <TabsContent value="idcard">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <IdCard className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">ID Card Generator</h3>
                </div>
                <p className="text-muted-foreground mb-4">Generate student ID cards</p>
                <Button>Generate ID Card</Button>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartSchool;
