import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Compass, Hotel, Map, Star } from "lucide-react";

const SmartTourist = () => {
  const places = [
    { name: "Cox's Bazar", rating: 4.8, image: "🏖️" },
    { name: "Sundarbans", rating: 4.9, image: "🌴" },
    { name: "Sajek Valley", rating: 4.7, image: "⛰️" },
  ];

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Compass className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Tourist</h1>
              <p className="text-muted-foreground">AI-powered travel planner and booking</p>
            </div>
          </div>

          <Tabs defaultValue="places">
            <TabsList>
              <TabsTrigger value="places">Places</TabsTrigger>
              <TabsTrigger value="hotels">Hotels</TabsTrigger>
              <TabsTrigger value="packages">Tour Packages</TabsTrigger>
              <TabsTrigger value="bookings">My Bookings</TabsTrigger>
            </TabsList>

            <TabsContent value="places" className="mt-6">
              <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                {places.map((place) => (
                  <Card key={place.name} className="overflow-hidden">
                    <div className="h-48 bg-muted flex items-center justify-center text-6xl">
                      {place.image}
                    </div>
                    <div className="p-4">
                      <h3 className="font-semibold text-lg mb-2">{place.name}</h3>
                      <div className="flex items-center gap-1 mb-3">
                        <Star className="h-4 w-4 fill-yellow-500 text-yellow-500" />
                        <span className="text-sm font-medium">{place.rating}</span>
                      </div>
                      <Button size="sm" className="w-full">View Details</Button>
                    </div>
                  </Card>
                ))}
              </div>
            </TabsContent>

            <TabsContent value="hotels">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Hotel className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Find Hotels</h3>
                </div>
                <p className="text-muted-foreground">Browse available hotels and resorts</p>
              </Card>
            </TabsContent>

            <TabsContent value="packages">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Map className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Tour Packages</h3>
                </div>
                <p className="text-muted-foreground">Curated tour packages with AI suggestions</p>
              </Card>
            </TabsContent>

            <TabsContent value="bookings">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">My Bookings</h3>
                <p className="text-muted-foreground">Your bookings will appear here</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartTourist;
