import { useState } from "react";
import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Switch } from "@/components/ui/switch";
import { Label } from "@/components/ui/label";
import { Baby, Mic, Camera, Shield, Volume2, Heart } from "lucide-react";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";

const StudioAVA = () => {
  const [childMode, setChildMode] = useState(false);
  const [voiceOnly, setVoiceOnly] = useState(false);
  const [emotionDetection, setEmotionDetection] = useState(true);

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-4xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Baby className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">AVA Mode</h1>
              <p className="text-muted-foreground">Child-safe AI assistant with voice & emotion support</p>
            </div>
          </div>

          <Tabs defaultValue="settings" className="mb-6">
            <TabsList>
              <TabsTrigger value="settings">Settings</TabsTrigger>
              <TabsTrigger value="interaction">Interaction</TabsTrigger>
              <TabsTrigger value="safety">Safety Controls</TabsTrigger>
            </TabsList>

            <TabsContent value="settings" className="space-y-6">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                  <Shield className="h-5 w-5 text-primary" />
                  Child Safety Mode
                </h3>
                <div className="space-y-4">
                  <div className="flex items-center justify-between">
                    <div>
                      <Label htmlFor="child-mode">Enable Child Mode</Label>
                      <p className="text-sm text-muted-foreground">Safe, age-appropriate responses</p>
                    </div>
                    <Switch
                      id="child-mode"
                      checked={childMode}
                      onCheckedChange={setChildMode}
                    />
                  </div>

                  <div className="flex items-center justify-between">
                    <div>
                      <Label htmlFor="voice-only">Voice-Only Mode</Label>
                      <p className="text-sm text-muted-foreground">Interact using voice commands only</p>
                    </div>
                    <Switch
                      id="voice-only"
                      checked={voiceOnly}
                      onCheckedChange={setVoiceOnly}
                    />
                  </div>

                  <div className="flex items-center justify-between">
                    <div>
                      <Label htmlFor="emotion">Emotion Detection</Label>
                      <p className="text-sm text-muted-foreground">Detect and respond to emotions</p>
                    </div>
                    <Switch
                      id="emotion"
                      checked={emotionDetection}
                      onCheckedChange={setEmotionDetection}
                    />
                  </div>
                </div>
              </Card>

              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                  <Volume2 className="h-5 w-5 text-primary" />
                  Voice & Audio
                </h3>
                <div className="space-y-4">
                  <div className="flex items-center gap-4">
                    <Button variant="outline" className="flex-1">
                      <Mic className="h-4 w-4 mr-2" />
                      Test Microphone
                    </Button>
                    <Button variant="outline" className="flex-1">
                      <Volume2 className="h-4 w-4 mr-2" />
                      Test Speaker
                    </Button>
                  </div>
                </div>
              </Card>
            </TabsContent>

            <TabsContent value="interaction">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                  <Heart className="h-5 w-5 text-primary" />
                  Simple Actions
                </h3>
                <div className="grid grid-cols-2 md:grid-cols-3 gap-4">
                  {["Tell a Story", "Sing a Song", "Play a Game", "Learn Colors", "Count Numbers", "Draw Picture"].map((action) => (
                    <Button key={action} variant="outline" className="h-20">
                      {action}
                    </Button>
                  ))}
                </div>
              </Card>
            </TabsContent>

            <TabsContent value="safety">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                  <Shield className="h-5 w-5 text-primary" />
                  Safety Controls
                </h3>
                <div className="space-y-4">
                  <div className="p-4 bg-green-500/10 border border-green-500/20 rounded-lg">
                    <p className="text-sm text-green-600 dark:text-green-400">
                      ✓ Content filtering enabled
                    </p>
                  </div>
                  <div className="p-4 bg-green-500/10 border border-green-500/20 rounded-lg">
                    <p className="text-sm text-green-600 dark:text-green-400">
                      ✓ Age-appropriate responses only
                    </p>
                  </div>
                  <div className="p-4 bg-green-500/10 border border-green-500/20 rounded-lg">
                    <p className="text-sm text-green-600 dark:text-green-400">
                      ✓ No external links or unsafe content
                    </p>
                  </div>
                </div>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default StudioAVA;
