import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { TrendingUp, DollarSign, Users, Target, Download } from "lucide-react";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";

const StudioAffiliateAnalytics = () => {
  const stats = {
    totalEarnings: 1250.50,
    pendingPayout: 340.25,
    totalReferrals: 45,
    conversionRate: 12.5,
  };

  const payouts = [
    { id: "1", date: "2024-01-15", amount: 500, status: "Paid", method: "bKash" },
    { id: "2", date: "2024-01-20", amount: 340.25, status: "Pending", method: "Nagad" },
  ];

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center justify-between mb-6">
            <div className="flex items-center gap-3">
              <TrendingUp className="h-8 w-8 text-primary" />
              <div>
                <h1 className="text-3xl font-bold text-foreground">Affiliate Analytics</h1>
                <p className="text-muted-foreground">Track your earnings and referrals</p>
              </div>
            </div>
            <Button>
              <Download className="h-4 w-4 mr-2" />
              Export Report
            </Button>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
            <Card className="p-6">
              <div className="flex items-center justify-between mb-2">
                <p className="text-sm text-muted-foreground">Total Earnings</p>
                <DollarSign className="h-5 w-5 text-green-500" />
              </div>
              <p className="text-2xl font-bold text-foreground">${stats.totalEarnings}</p>
              <p className="text-xs text-green-600 mt-1">+12% from last month</p>
            </Card>

            <Card className="p-6">
              <div className="flex items-center justify-between mb-2">
                <p className="text-sm text-muted-foreground">Pending Payout</p>
                <DollarSign className="h-5 w-5 text-yellow-500" />
              </div>
              <p className="text-2xl font-bold text-foreground">${stats.pendingPayout}</p>
              <p className="text-xs text-muted-foreground mt-1">Request payout</p>
            </Card>

            <Card className="p-6">
              <div className="flex items-center justify-between mb-2">
                <p className="text-sm text-muted-foreground">Total Referrals</p>
                <Users className="h-5 w-5 text-blue-500" />
              </div>
              <p className="text-2xl font-bold text-foreground">{stats.totalReferrals}</p>
              <p className="text-xs text-blue-600 mt-1">+8 this month</p>
            </Card>

            <Card className="p-6">
              <div className="flex items-center justify-between mb-2">
                <p className="text-sm text-muted-foreground">Conversion Rate</p>
                <Target className="h-5 w-5 text-purple-500" />
              </div>
              <p className="text-2xl font-bold text-foreground">{stats.conversionRate}%</p>
              <p className="text-xs text-purple-600 mt-1">Above average</p>
            </Card>
          </div>

          <Tabs defaultValue="overview" className="mb-6">
            <TabsList>
              <TabsTrigger value="overview">Overview</TabsTrigger>
              <TabsTrigger value="payouts">Payout History</TabsTrigger>
              <TabsTrigger value="modules">Module Performance</TabsTrigger>
            </TabsList>

            <TabsContent value="overview">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">Earnings Over Time</h3>
                <div className="h-64 flex items-center justify-center bg-muted/30 rounded-lg">
                  <p className="text-muted-foreground">Chart placeholder</p>
                </div>
              </Card>
            </TabsContent>

            <TabsContent value="payouts">
              <Card className="p-6">
                <div className="flex items-center justify-between mb-4">
                  <h3 className="text-lg font-semibold">Payout History</h3>
                  <Button>Request Payout</Button>
                </div>
                <div className="space-y-3">
                  {payouts.map((payout) => (
                    <div key={payout.id} className="flex items-center justify-between p-4 bg-muted/50 rounded-lg">
                      <div>
                        <p className="font-medium text-foreground">${payout.amount}</p>
                        <p className="text-sm text-muted-foreground">{payout.date} • {payout.method}</p>
                      </div>
                      <span className={`text-sm px-3 py-1 rounded-full ${
                        payout.status === "Paid" 
                          ? "bg-green-500/10 text-green-600" 
                          : "bg-yellow-500/10 text-yellow-600"
                      }`}>
                        {payout.status}
                      </span>
                    </div>
                  ))}
                </div>
              </Card>
            </TabsContent>

            <TabsContent value="modules">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">Top Performing Modules</h3>
                <p className="text-muted-foreground">Module performance analytics coming soon...</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default StudioAffiliateAnalytics;
