import { useState } from "react";
import { BuildExportPanel } from "@/components/ide/BuildExportPanel";
import { WalletGuard } from "@/components/ide/WalletGuard";
import { Button } from "@/components/ui/button";
import { ArrowLeft } from "lucide-react";
import { useNavigate } from "react-router-dom";

const StudioBuild = () => {
  const [projectId] = useState("default-project");
  const navigate = useNavigate();

  return (
    <WalletGuard>
      <div className="h-screen bg-background flex flex-col">
        <div className="border-b border-border p-4 flex items-center gap-4">
          <Button
            variant="ghost"
            size="sm"
            onClick={() => navigate("/studio")}
            className="gap-2"
          >
            <ArrowLeft className="h-4 w-4" />
            Back to Studio
          </Button>
          <h1 className="text-xl font-semibold text-foreground">Build & Export</h1>
        </div>
        <div className="flex-1 overflow-hidden">
          <BuildExportPanel projectId={projectId} />
        </div>
      </div>
    </WalletGuard>
  );
};

export default StudioBuild;
