import { useState } from "react";
import { OwnerGuard } from "@/components/OwnerGuard";
import { FileInspector } from "@/components/ide/FileInspector";
import { DevBrainPanel } from "@/components/ide/DevBrainPanel";
import { DevHistoryViewer } from "@/components/ide/DevHistoryViewer";
import { FileInfo } from "@/core/devBrain/DevBrainFileOps";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Brain, History } from "lucide-react";

const StudioDev = () => {
  const [selectedFile, setSelectedFile] = useState<FileInfo | null>(null);

  return (
    <OwnerGuard>
      <div className="h-screen flex flex-col bg-background">
        {/* Header */}
        <div className="border-b border-border bg-card">
          <div className="container mx-auto px-4 py-4">
            <div className="flex items-center gap-3">
              <Brain className="h-8 w-8 text-primary" />
              <div>
                <h1 className="text-2xl font-bold text-foreground">Dev Studio</h1>
                <p className="text-sm text-muted-foreground">
                  AI-powered development tools for Smart Friend
                </p>
              </div>
            </div>
          </div>
        </div>

        {/* Main Content */}
        <div className="flex-1 overflow-hidden">
          <div className="container mx-auto h-full p-4">
            <div className="grid grid-cols-12 gap-4 h-full">
              {/* File Inspector */}
              <div className="col-span-3 border border-border rounded-lg bg-card overflow-hidden">
                <FileInspector
                  onFileSelect={setSelectedFile}
                  selectedFile={selectedFile}
                />
              </div>

              {/* Main Panel */}
              <div className="col-span-9">
                <Tabs defaultValue="brain" className="h-full flex flex-col">
                  <TabsList className="w-full justify-start">
                    <TabsTrigger value="brain" className="gap-2">
                      <Brain className="h-4 w-4" />
                      Dev Brain
                    </TabsTrigger>
                    <TabsTrigger value="history" className="gap-2">
                      <History className="h-4 w-4" />
                      History
                    </TabsTrigger>
                  </TabsList>

                  <div className="flex-1 border border-border rounded-lg bg-card overflow-hidden mt-4">
                    <TabsContent value="brain" className="h-full m-0">
                      <DevBrainPanel selectedFile={selectedFile} />
                    </TabsContent>

                    <TabsContent value="history" className="h-full m-0">
                      <DevHistoryViewer />
                    </TabsContent>
                  </div>
                </Tabs>
              </div>
            </div>
          </div>
        </div>
      </div>
    </OwnerGuard>
  );
};

export default StudioDev;
