import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Switch } from "@/components/ui/switch";
import { Label } from "@/components/ui/label";
import { Link2, Share2, Database, Bell, Calendar } from "lucide-react";

const StudioIntegration = () => {
  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-4xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Link2 className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Friend 2 Integration</h1>
              <p className="text-muted-foreground">Connect and sync with Smart Friend 2</p>
            </div>
          </div>

          <div className="space-y-6">
            <Card className="p-6">
              <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                <Share2 className="h-5 w-5 text-primary" />
                Shared Features
              </h3>
              <div className="space-y-4">
                <div className="flex items-center justify-between">
                  <div>
                    <Label>Shared Memory</Label>
                    <p className="text-sm text-muted-foreground">Sync AI memory across versions</p>
                  </div>
                  <Switch defaultChecked />
                </div>

                <div className="flex items-center justify-between">
                  <div>
                    <Label>Shared Reminders</Label>
                    <p className="text-sm text-muted-foreground">Access reminders from both versions</p>
                  </div>
                  <Switch defaultChecked />
                </div>

                <div className="flex items-center justify-between">
                  <div>
                    <Label>Shared Notes</Label>
                    <p className="text-sm text-muted-foreground">Sync notes across devices</p>
                  </div>
                  <Switch defaultChecked />
                </div>
              </div>
            </Card>

            <Card className="p-6">
              <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                <Database className="h-5 w-5 text-primary" />
                Data Synchronization
              </h3>
              <div className="space-y-4">
                <div className="flex items-center justify-between">
                  <span className="text-sm">Last Sync</span>
                  <span className="text-sm text-muted-foreground">2 minutes ago</span>
                </div>
                <Button className="w-full">Sync Now</Button>
              </div>
            </Card>

            <Card className="p-6">
              <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                <Bell className="h-5 w-5 text-primary" />
                Parent-Child Safe Interaction
              </h3>
              <div className="space-y-4">
                <div className="p-4 bg-green-500/10 border border-green-500/20 rounded-lg">
                  <p className="text-sm text-green-600 dark:text-green-400 mb-2">
                    ✓ Safe mode enabled
                  </p>
                  <p className="text-xs text-muted-foreground">
                    All interactions are filtered for child safety
                  </p>
                </div>

                <div className="flex items-center justify-between">
                  <div>
                    <Label>Parent Monitoring</Label>
                    <p className="text-sm text-muted-foreground">Allow parent oversight</p>
                  </div>
                  <Switch defaultChecked />
                </div>

                <div className="flex items-center justify-between">
                  <div>
                    <Label>Activity Logs</Label>
                    <p className="text-sm text-muted-foreground">Track child interactions</p>
                  </div>
                  <Switch defaultChecked />
                </div>
              </div>
            </Card>

            <Card className="p-6">
              <h3 className="text-lg font-semibold mb-4 flex items-center gap-2">
                <Calendar className="h-5 w-5 text-primary" />
                Migration Status
              </h3>
              <div className="space-y-3">
                <div className="flex justify-between items-center">
                  <span className="text-sm">Memory</span>
                  <span className="text-sm text-green-600">✓ Migrated</span>
                </div>
                <div className="flex justify-between items-center">
                  <span className="text-sm">Reminders</span>
                  <span className="text-sm text-green-600">✓ Migrated</span>
                </div>
                <div className="flex justify-between items-center">
                  <span className="text-sm">Notes</span>
                  <span className="text-sm text-green-600">✓ Migrated</span>
                </div>
                <div className="flex justify-between items-center">
                  <span className="text-sm">User Profile</span>
                  <span className="text-sm text-green-600">✓ Migrated</span>
                </div>
              </div>
            </Card>
          </div>
        </div>
      </div>
    </WalletGuard>
  );
};

export default StudioIntegration;
