import { useState } from "react";
import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Store, Search, Star, Download, DollarSign, Code, Zap } from "lucide-react";

const StudioMarketplace = () => {
  const [searchQuery, setSearchQuery] = useState("");

  const modules = [
    { id: "1", name: "E-commerce Pro", category: "Business", price: 49, rating: 4.8, downloads: 1250, type: "module" },
    { id: "2", name: "AI Code Assistant", category: "AI Tools", price: 29, rating: 4.9, downloads: 2100, type: "ai-tool" },
    { id: "3", name: "Medical Records System", category: "Medical", price: 79, rating: 4.7, downloads: 890, type: "module" },
    { id: "4", name: "Salon Booking System", category: "Salon", price: 39, rating: 4.6, downloads: 650, type: "module" },
    { id: "5", name: "AI Image Generator", category: "AI Tools", price: 25, rating: 4.9, downloads: 3200, type: "ai-tool" },
  ];

  const filteredModules = modules.filter(m => 
    m.name.toLowerCase().includes(searchQuery.toLowerCase()) ||
    m.category.toLowerCase().includes(searchQuery.toLowerCase())
  );

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Store className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Marketplace</h1>
              <p className="text-muted-foreground">Discover modules & AI tools for your projects</p>
            </div>
          </div>

          <div className="mb-6">
            <div className="relative">
              <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
              <Input
                placeholder="Search modules, AI tools..."
                value={searchQuery}
                onChange={(e) => setSearchQuery(e.target.value)}
                className="pl-10"
              />
            </div>
          </div>

          <Tabs defaultValue="all" className="mb-6">
            <TabsList>
              <TabsTrigger value="all">All</TabsTrigger>
              <TabsTrigger value="modules">Modules</TabsTrigger>
              <TabsTrigger value="ai-tools">AI Tools</TabsTrigger>
              <TabsTrigger value="popular">Popular</TabsTrigger>
              <TabsTrigger value="new">New</TabsTrigger>
            </TabsList>

            <TabsContent value="all" className="mt-6">
              <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {filteredModules.map((item) => (
                  <Card key={item.id} className="p-6 hover:shadow-lg transition-shadow">
                    <div className="flex items-start justify-between mb-4">
                      <div className="flex items-center gap-2">
                        {item.type === "ai-tool" ? (
                          <Zap className="h-5 w-5 text-purple-500" />
                        ) : (
                          <Code className="h-5 w-5 text-blue-500" />
                        )}
                        <Badge variant="outline">{item.category}</Badge>
                      </div>
                      <div className="flex items-center gap-1 text-yellow-500">
                        <Star className="h-4 w-4 fill-current" />
                        <span className="text-sm font-medium">{item.rating}</span>
                      </div>
                    </div>

                    <h3 className="text-lg font-semibold text-foreground mb-2">{item.name}</h3>
                    
                    <div className="flex items-center gap-4 text-sm text-muted-foreground mb-4">
                      <div className="flex items-center gap-1">
                        <Download className="h-4 w-4" />
                        {item.downloads}
                      </div>
                      <div className="flex items-center gap-1">
                        <DollarSign className="h-4 w-4" />
                        ${item.price}
                      </div>
                    </div>

                    <div className="flex gap-2">
                      <Button variant="outline" className="flex-1">Preview</Button>
                      <Button className="flex-1">Buy Now</Button>
                    </div>
                  </Card>
                ))}
              </div>
            </TabsContent>

            <TabsContent value="modules">
              <p className="text-muted-foreground">Module marketplace coming soon...</p>
            </TabsContent>

            <TabsContent value="ai-tools">
              <p className="text-muted-foreground">AI tools marketplace coming soon...</p>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default StudioMarketplace;
