import { MemorySettings } from "@/components/ide/MemorySettings";
import { WalletGuard } from "@/components/ide/WalletGuard";
import { Database } from "lucide-react";

const StudioMemory = () => {
  return (
    <WalletGuard>
      <div className="h-screen bg-gradient-to-br from-primary/5 via-background to-secondary/5 p-6 overflow-y-auto">
        <div className="max-w-4xl mx-auto space-y-6">
          <div className="flex items-center gap-3">
            <div className="p-3 bg-gradient-to-br from-primary/20 to-secondary/20 rounded-xl">
              <Database className="h-8 w-8 text-primary" />
            </div>
            <div>
              <h1 className="text-3xl font-bold bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent">
                Memory Engine
              </h1>
              <p className="text-muted-foreground">Manage your long-term project memory</p>
            </div>
          </div>

          <MemorySettings projectId="default-project" />
        </div>
      </div>
    </WalletGuard>
  );
};

export default StudioMemory;
