import { SubscriptionPlans } from "@/components/studio/SubscriptionPlans";
import { CreditCard } from "lucide-react";

const StudioSubscription = () => {
  return (
    <div className="h-screen bg-gradient-to-br from-primary/5 via-background to-secondary/5 p-6 overflow-y-auto">
      <div className="max-w-6xl mx-auto space-y-6">
        <div className="flex items-center gap-3">
          <div className="p-3 bg-gradient-to-br from-primary/20 to-secondary/20 rounded-xl">
            <CreditCard className="h-8 w-8 text-primary" />
          </div>
          <div>
            <h1 className="text-3xl font-bold bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent">
              Subscription Plans
            </h1>
            <p className="text-muted-foreground">Choose the perfect plan for your needs</p>
          </div>
        </div>

        <SubscriptionPlans />
      </div>
    </div>
  );
};

export default StudioSubscription;
