import { SmartWallet } from "@/components/studio/SmartWallet";
import { Wallet } from "lucide-react";

const StudioWallet = () => {
  return (
    <div className="h-screen bg-gradient-to-br from-primary/5 via-background to-secondary/5 p-6 overflow-y-auto">
      <div className="max-w-4xl mx-auto space-y-6">
        <div className="flex items-center gap-3">
          <div className="p-3 bg-gradient-to-br from-primary/20 to-secondary/20 rounded-xl">
            <Wallet className="h-8 w-8 text-primary" />
          </div>
          <div>
            <h1 className="text-3xl font-bold bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent">
              Smart Wallet
            </h1>
            <p className="text-muted-foreground">Manage your balance and transactions</p>
          </div>
        </div>

        <SmartWallet />
      </div>
    </div>
  );
};

export default StudioWallet;
