import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Label } from "@/components/ui/label";
import { Switch } from "@/components/ui/switch";
import { RadioGroup, RadioGroupItem } from "@/components/ui/radio-group";
import { Button } from "@/components/ui/button";
import { Mic, Volume2, Play } from "lucide-react";
import { useVoiceSystem } from "@/hooks/useVoiceSystem";

const VoiceSettings = () => {
  const {
    voiceEnabled,
    voiceProfile,
    toggleVoice,
    changeVoiceProfile,
    speak,
  } = useVoiceSystem();

  const testVoice = () => {
    speak("Hello, I am Smart Friend. This is a test of the voice output system.");
  };

  return (
    <div className="min-h-screen bg-background p-6">
      <div className="max-w-2xl mx-auto space-y-6">
        <div className="flex items-center gap-3">
          <Volume2 className="h-8 w-8 text-primary" />
          <div>
            <h1 className="text-3xl font-bold text-foreground">Voice Settings</h1>
            <p className="text-muted-foreground">Configure voice input and output</p>
          </div>
        </div>

        {/* Voice Output */}
        <Card>
          <CardHeader>
            <CardTitle>Voice Output</CardTitle>
          </CardHeader>
          <CardContent className="space-y-6">
            <div className="flex items-center justify-between">
              <div>
                <Label htmlFor="voice-enabled">Enable Voice Output</Label>
                <p className="text-xs text-muted-foreground">
                  AI responses will be spoken aloud
                </p>
              </div>
              <Switch
                id="voice-enabled"
                checked={voiceEnabled}
                onCheckedChange={toggleVoice}
              />
            </div>

            <div className="space-y-3">
              <Label>Voice Profile</Label>
              <RadioGroup value={voiceProfile} onValueChange={changeVoiceProfile}>
                <div className="flex items-center space-x-2">
                  <RadioGroupItem value="male" id="male" />
                  <Label htmlFor="male">Male Voice</Label>
                </div>
                <div className="flex items-center space-x-2">
                  <RadioGroupItem value="female" id="female" />
                  <Label htmlFor="female">Female Voice</Label>
                </div>
                <div className="flex items-center space-x-2">
                  <RadioGroupItem value="neutral" id="neutral" />
                  <Label htmlFor="neutral">Neutral Voice</Label>
                </div>
              </RadioGroup>
            </div>

            <Button onClick={testVoice} variant="outline">
              <Play className="h-4 w-4 mr-2" />
              Test Voice
            </Button>
          </CardContent>
        </Card>

        {/* Voice Input */}
        <Card>
          <CardHeader>
            <CardTitle>Voice Input</CardTitle>
          </CardHeader>
          <CardContent>
            <div className="flex items-center gap-2 p-4 bg-muted rounded-lg">
              <Mic className="h-5 w-5 text-muted-foreground" />
              <div>
                <p className="text-sm font-medium">Microphone Access</p>
                <p className="text-xs text-muted-foreground">
                  Click the microphone button in chat to use voice input
                </p>
              </div>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  );
};

export default VoiceSettings;
