// Phase 3: Module Blueprint Types

export interface BlueprintField {
  name: string;
  type: 'string' | 'number' | 'boolean' | 'date' | 'text' | 'json' | 'reference';
  required: boolean;
  defaultValue?: any;
  validation?: string;
  referenceEntity?: string;
  isUnique?: boolean;
  isSearchable?: boolean;
}

export interface BlueprintEntity {
  name: string;
  displayName: string;
  fields: BlueprintField[];
  hasTimestamps: boolean;
  hasSoftDelete: boolean;
  hasOwnership: boolean;
}

export interface BlueprintRelationship {
  type: 'one-to-one' | 'one-to-many' | 'many-to-many';
  from: string;
  to: string;
  cascadeDelete?: boolean;
}

export interface BlueprintPage {
  type: 'list' | 'form' | 'view' | 'dashboard';
  entity: string;
  title: string;
  route: string;
  permissions: string[];
  fields?: string[];
}

export interface BlueprintAPIRoute {
  method: 'GET' | 'POST' | 'PUT' | 'DELETE';
  path: string;
  entity: string;
  action: string;
  auth: boolean;
  permissions: string[];
}

export interface ModuleBlueprint {
  id?: string;
  name: string;
  slug: string;
  description: string;
  naturalDescription?: string;
  
  // Structure
  entities: BlueprintEntity[];
  relationships: BlueprintRelationship[];
  uiPages: BlueprintPage[];
  apiRoutes: BlueprintAPIRoute[];
  
  // Tech stack
  backendStack: 'laravel' | 'dotnet' | 'express';
  frontendStack: 'react' | 'next' | 'vue';
  
  // Configuration
  permissions: string[];
  menuItems: MenuItem[];
  complexity: 'simple' | 'medium' | 'complex';
  
  // Generation
  status: 'draft' | 'generating' | 'generated' | 'applied' | 'failed';
  generatedFiles?: Record<string, string>;
  generationLog?: string;
  
  // Metadata
  version: string;
  tags?: string[];
  createdBy?: string;
  createdAt?: string;
  updatedAt?: string;
}

export interface MenuItem {
  label: string;
  route: string;
  icon: string;
  order: number;
  parent?: string;
}

export interface ProjectBlueprint {
  name: string;
  description: string;
  type: 'laravel-api' | 'laravel-react' | 'dotnet-react' | 'nextjs' | 'react-spa';
  modules: ModuleBlueprint[];
  database: 'mysql' | 'postgresql' | 'sqlite';
  authentication: boolean;
  features: string[];
}

export interface SystemUpgrade {
  id?: string;
  version: string;
  upgradeType: 'feature' | 'optimization' | 'bugfix' | 'security';
  description: string;
  affectedFiles: string[];
  patchContent: string;
  diffPreview: string;
  status: 'pending' | 'applied' | 'failed' | 'rolled-back';
  detectionMethod: 'auto' | 'manual';
  optimizationScore?: number;
}
