export interface SearchResult {
  title: string;
  url: string;
  snippet: string;
  source: string;
  score?: number;
  faviconUrl?: string;
  publishedDate?: string;
}

export interface SearchResponse {
  results: SearchResult[];
  query: string;
  tookMs: number;
  lang?: string;
  module?: string;
}

export interface SearchOptions {
  query: string;
  lang?: string;
  maxResults?: number;
  module?: string;
  safeSearch?: boolean;
}

export interface SearchSettings {
  enabled: boolean;
  perModuleSettings: {
    [key: string]: boolean;
  };
  maxResults: number;
  safeSearch: boolean;
  rateLimit: number; // requests per minute
}
