export const formatCallDuration = (startedAt: string, endedAt: string | null): string => {
  if (!endedAt) return "0:00";
  
  const start = new Date(startedAt);
  const end = new Date(endedAt);
  const durationMs = end.getTime() - start.getTime();
  const durationSeconds = Math.floor(durationMs / 1000);
  
  const hours = Math.floor(durationSeconds / 3600);
  const minutes = Math.floor((durationSeconds % 3600) / 60);
  const seconds = durationSeconds % 60;
  
  if (hours > 0) {
    return `${hours}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
  }
  
  return `${minutes}:${seconds.toString().padStart(2, '0')}`;
};

export const getCallStatusText = (
  status: string,
  callType: string,
  isIncoming: boolean
): string => {
  if (status === "ended") {
    return isIncoming ? "Incoming" : "Outgoing";
  }
  if (status === "declined") {
    return "Declined";
  }
  if (status === "missed") {
    return "Missed";
  }
  return status;
};

export const getCallStatusColor = (status: string): string => {
  switch (status) {
    case "ended":
      return "text-green-600 dark:text-green-400";
    case "declined":
      return "text-red-600 dark:text-red-400";
    case "missed":
      return "text-orange-600 dark:text-orange-400";
    default:
      return "text-muted-foreground";
  }
};
