-- Create generated_tests table for storing AI-generated unit tests
CREATE TABLE IF NOT EXISTS public.generated_tests (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  scan_result_id UUID REFERENCES public.scan_results(id) ON DELETE CASCADE,
  test_file_path TEXT NOT NULL,
  test_code TEXT NOT NULL,
  test_framework TEXT NOT NULL DEFAULT 'vitest',
  description TEXT,
  status TEXT NOT NULL DEFAULT 'pending', -- pending, approved, rejected
  created_at TIMESTAMPTZ NOT NULL DEFAULT now(),
  created_by UUID NOT NULL,
  applied_at TIMESTAMPTZ
);

-- Enable RLS
ALTER TABLE public.generated_tests ENABLE ROW LEVEL SECURITY;

-- RLS Policies for Core Brain owners
CREATE POLICY "Core Brain owners can view generated tests"
  ON public.generated_tests
  FOR SELECT
  USING (is_core_brain_owner());

CREATE POLICY "Core Brain owners can insert generated tests"
  ON public.generated_tests
  FOR INSERT
  WITH CHECK (is_core_brain_owner() AND auth.uid() = created_by);

CREATE POLICY "Core Brain owners can update generated tests"
  ON public.generated_tests
  FOR UPDATE
  USING (is_core_brain_owner());

CREATE POLICY "Core Brain owners can delete generated tests"
  ON public.generated_tests
  FOR DELETE
  USING (is_core_brain_owner());

-- Create index for better query performance
CREATE INDEX IF NOT EXISTS idx_generated_tests_status ON public.generated_tests(status);
CREATE INDEX IF NOT EXISTS idx_generated_tests_scan_result ON public.generated_tests(scan_result_id);