-- Insert 50+ module templates for instant generation
INSERT INTO module_templates (name, slug, category, description, template_config) VALUES
('Smart Salon', 'smart-salon', 'Beauty & Wellness', 'Complete salon management system', '{"framework": "react", "features": ["booking", "staff", "services", "payments"], "permissions": ["manage_bookings"], "actions": ["book", "cancel"], "ai_suggestions": ["optimize_schedule"]}'),
('Smart Makeup', 'smart-makeup', 'Beauty & Wellness', 'Makeup artist booking platform', '{"framework": "react", "features": ["portfolio", "booking", "gallery"], "permissions": ["manage_bookings"], "actions": ["book"], "ai_suggestions": []}'),
('Smart Bazar', 'smart-bazar', 'E-Commerce', 'Multi-tenant marketplace', '{"framework": "react", "features": ["products", "cart", "checkout", "vendors"], "permissions": ["manage_products"], "actions": ["buy", "sell"], "ai_suggestions": ["recommend_products"], "is_multi_tenant": true}'),
('Smart Hospital', 'smart-hospital', 'Healthcare', 'Hospital management system', '{"framework": "react", "features": ["appointments", "patients", "doctors", "billing"], "permissions": ["manage_patients"], "actions": ["schedule"], "ai_suggestions": ["diagnose"]}'),
('Smart Academy', 'smart-academy', 'Education', 'Online learning platform', '{"framework": "react", "features": ["courses", "students", "teachers", "exams"], "permissions": ["manage_courses"], "actions": ["enroll"], "ai_suggestions": ["recommend_courses"]}'),
('Smart Pay', 'smart-pay', 'Finance', 'Payment gateway system', '{"framework": "react", "features": ["payments", "wallets", "transactions"], "permissions": ["process_payments"], "actions": ["pay", "transfer"], "ai_suggestions": []}'),
('Smart Lawyer', 'smart-lawyer', 'Legal', 'Legal case management', '{"framework": "react", "features": ["cases", "clients", "documents"], "permissions": ["manage_cases"], "actions": ["file_case"], "ai_suggestions": ["legal_advice"]}'),
('Smart News', 'smart-news', 'Media', 'News publishing platform', '{"framework": "react", "features": ["articles", "authors", "categories"], "permissions": ["publish"], "actions": ["write", "publish"], "ai_suggestions": ["generate_headlines"]}'),
('Smart Marketer', 'smart-marketer', 'Marketing', 'Marketing automation tool', '{"framework": "react", "features": ["campaigns", "analytics", "leads"], "permissions": ["manage_campaigns"], "actions": ["launch"], "ai_suggestions": ["optimize_campaign"]}'),
('Smart Design Hub', 'smart-design-hub', 'Creative', 'Design project management', '{"framework": "react", "features": ["projects", "assets", "collaboration"], "permissions": ["manage_designs"], "actions": ["create"], "ai_suggestions": ["suggest_colors"]}'),
('Smart Tourist', 'smart-tourist', 'Travel', 'Tourism management system', '{"framework": "react", "features": ["destinations", "bookings", "guides"], "permissions": ["manage_tours"], "actions": ["book_tour"], "ai_suggestions": ["recommend_destinations"]}'),
('Smart Doctor', 'smart-doctor', 'Healthcare', 'Doctor appointment system', '{"framework": "react", "features": ["appointments", "prescriptions", "patients"], "permissions": ["manage_appointments"], "actions": ["prescribe"], "ai_suggestions": ["diagnose"]}'),
('Smart AI Ad', 'smart-ai-ad', 'Marketing', 'AI-powered advertising', '{"framework": "react", "features": ["ads", "targeting", "analytics"], "permissions": ["manage_ads"], "actions": ["create_ad"], "ai_suggestions": ["generate_ad_copy"]}'),
('Smart Transport', 'smart-transport', 'Logistics', 'Transportation management', '{"framework": "react", "features": ["vehicles", "routes", "tracking"], "permissions": ["manage_fleet"], "actions": ["dispatch"], "ai_suggestions": ["optimize_routes"]}'),
('Smart School', 'smart-school', 'Education', 'School management system', '{"framework": "react", "features": ["students", "teachers", "classes", "attendance"], "permissions": ["manage_school"], "actions": ["enroll"], "ai_suggestions": []}'),
('Smart FNF', 'smart-fnf', 'Social Media', 'Social networking platform', '{"framework": "react", "features": ["posts", "friends", "messages", "feed"], "permissions": ["post"], "actions": ["share", "like"], "ai_suggestions": ["suggest_friends"]}'),
('Smart Hisab', 'smart-hisab', 'Finance', 'Accounting system', '{"framework": "react", "features": ["ledger", "reports", "invoices"], "permissions": ["manage_accounts"], "actions": ["record"], "ai_suggestions": ["forecast"]}'),
('Smart Hotel', 'smart-hotel', 'Hospitality', 'Hotel management system', '{"framework": "react", "features": ["rooms", "bookings", "guests", "billing"], "permissions": ["manage_bookings"], "actions": ["book_room"], "ai_suggestions": []}'),
('Smart Real Estate', 'smart-real-estate', 'Real Estate', 'Property management', '{"framework": "react", "features": ["properties", "agents", "listings"], "permissions": ["manage_properties"], "actions": ["list_property"], "ai_suggestions": ["price_estimate"]}'),
('Smart Construction', 'smart-construction', 'Construction', 'Construction project management', '{"framework": "react", "features": ["projects", "materials", "workers", "progress"], "permissions": ["manage_projects"], "actions": ["schedule"], "ai_suggestions": []}'),
('Smart Interior', 'smart-interior', 'Design', 'Interior design platform', '{"framework": "react", "features": ["designs", "3d_preview", "materials"], "permissions": ["create_designs"], "actions": ["design"], "ai_suggestions": ["suggest_layout"]}'),
('Smart Abacus', 'smart-abacus', 'Education', 'Abacus learning system', '{"framework": "react", "features": ["lessons", "practice", "tests"], "permissions": ["manage_lessons"], "actions": ["practice"], "ai_suggestions": []}'),
('Smart English', 'smart-english', 'Education', 'English learning platform', '{"framework": "react", "features": ["lessons", "exercises", "speaking"], "permissions": ["manage_courses"], "actions": ["learn"], "ai_suggestions": ["correct_grammar"]}'),
('Smart Coding', 'smart-coding', 'Education', 'Coding learning platform', '{"framework": "react", "features": ["courses", "coding_challenges", "projects"], "permissions": ["manage_courses"], "actions": ["code"], "ai_suggestions": ["debug_code"]}'),
('Smart eLearning', 'smart-elearning', 'Education', 'Online learning management', '{"framework": "react", "features": ["courses", "videos", "quizzes", "certificates"], "permissions": ["manage_courses"], "actions": ["enroll"], "ai_suggestions": ["recommend_courses"]}'),
('Smart Restaurant', 'smart-restaurant', 'Food & Beverage', 'Restaurant management', '{"framework": "react", "features": ["menu", "orders", "tables", "billing"], "permissions": ["manage_orders"], "actions": ["order"], "ai_suggestions": ["recommend_dishes"]}'),
('Smart Pharmacy', 'smart-pharmacy', 'Healthcare', 'Pharmacy management system', '{"framework": "react", "features": ["medicines", "prescriptions", "inventory"], "permissions": ["manage_inventory"], "actions": ["dispense"], "ai_suggestions": []}'),
('Smart Farmer', 'smart-farmer', 'Agriculture', 'Farm management system', '{"framework": "react", "features": ["crops", "livestock", "weather", "market"], "permissions": ["manage_farm"], "actions": ["plant", "harvest"], "ai_suggestions": ["crop_advice"]}'),
('Smart Labour', 'smart-labour', 'Human Resources', 'Labour management system', '{"framework": "react", "features": ["workers", "attendance", "payroll"], "permissions": ["manage_workers"], "actions": ["hire"], "ai_suggestions": []}'),
('Smart Complaint', 'smart-complaint', 'Customer Service', 'Complaint management system', '{"framework": "react", "features": ["complaints", "tracking", "resolution"], "permissions": ["manage_complaints"], "actions": ["file_complaint"], "ai_suggestions": ["suggest_resolution"]}'),
('Smart Certificate', 'smart-certificate', 'Education', 'Certificate generation system', '{"framework": "react", "features": ["templates", "generation", "verification"], "permissions": ["generate_certificates"], "actions": ["generate"], "ai_suggestions": []}'),
('Smart Announcement', 'smart-announcement', 'Communication', 'Announcement system', '{"framework": "react", "features": ["announcements", "notifications", "scheduling"], "permissions": ["publish_announcements"], "actions": ["announce"], "ai_suggestions": []}'),
('Smart SOS', 'smart-sos', 'Emergency', 'Emergency response system', '{"framework": "react", "features": ["alerts", "location", "contacts"], "permissions": ["send_sos"], "actions": ["alert"], "ai_suggestions": []}'),
('Smart LoRa Mesh', 'smart-lora-mesh', 'IoT', 'LoRa mesh network system', '{"framework": "react", "features": ["nodes", "messages", "monitoring"], "permissions": ["manage_network"], "actions": ["send_message"], "ai_suggestions": []}'),
('Smart Emotion Sense', 'smart-emotion-sense', 'AI', 'Emotion detection system', '{"framework": "react", "features": ["analysis", "reports", "insights"], "permissions": ["analyze_emotions"], "actions": ["detect"], "ai_suggestions": ["emotion_insights"]}'),
('Smart Witness AI', 'smart-witness-ai', 'Legal', 'AI witness documentation', '{"framework": "react", "features": ["recording", "transcription", "evidence"], "permissions": ["record_witness"], "actions": ["record"], "ai_suggestions": ["analyze_testimony"]}'),
('Smart DevOps', 'smart-devops', 'Development', 'DevOps automation platform', '{"framework": "react", "features": ["deployments", "monitoring", "ci_cd"], "permissions": ["deploy"], "actions": ["deploy"], "ai_suggestions": ["optimize_pipeline"]}'),
('Smart Auto Module Builder', 'smart-auto-module-builder', 'Development', 'Automatic module generation', '{"framework": "react", "features": ["templates", "generation", "customization"], "permissions": ["generate_modules"], "actions": ["generate"], "ai_suggestions": ["suggest_architecture"]}'),
('Smart UI Generator', 'smart-ui-generator', 'Design', 'UI component generator', '{"framework": "react", "features": ["components", "themes", "preview"], "permissions": ["generate_ui"], "actions": ["generate"], "ai_suggestions": ["suggest_design"]}'),
('Smart Logo Maker', 'smart-logo-maker', 'Design', 'AI logo generation', '{"framework": "react", "features": ["templates", "customization", "export"], "permissions": ["create_logos"], "actions": ["generate"], "ai_suggestions": ["suggest_style"]}'),
('Smart Poster Maker', 'smart-poster-maker', 'Design', 'Poster design tool', '{"framework": "react", "features": ["templates", "editor", "export"], "permissions": ["create_posters"], "actions": ["design"], "ai_suggestions": ["suggest_layout"]}'),
('Smart Photo Editor', 'smart-photo-editor', 'Creative', 'Photo editing platform', '{"framework": "react", "features": ["filters", "effects", "tools"], "permissions": ["edit_photos"], "actions": ["edit"], "ai_suggestions": ["enhance"]}'),
('Smart Video Editor', 'smart-video-editor', 'Creative', 'Video editing platform', '{"framework": "react", "features": ["timeline", "effects", "export"], "permissions": ["edit_videos"], "actions": ["edit"], "ai_suggestions": ["suggest_cuts"]}'),
('Smart Voiceover', 'smart-voiceover', 'Creative', 'AI voiceover generation', '{"framework": "react", "features": ["text_to_speech", "voices", "export"], "permissions": ["generate_voiceover"], "actions": ["generate"], "ai_suggestions": []}'),
('Smart Call Center', 'smart-call-center', 'Customer Service', 'Call center management', '{"framework": "react", "features": ["calls", "agents", "tickets"], "permissions": ["manage_calls"], "actions": ["call"], "ai_suggestions": ["suggest_response"]}'),
('Smart Social Media Automation', 'smart-social-media-automation', 'Marketing', 'Social media automation', '{"framework": "react", "features": ["scheduling", "posting", "analytics"], "permissions": ["manage_posts"], "actions": ["schedule_post"], "ai_suggestions": ["suggest_content"]}'),
('Smart Wallet', 'smart-wallet', 'Finance', 'Digital wallet system', '{"framework": "react", "features": ["balance", "transactions", "payments"], "permissions": ["manage_wallet"], "actions": ["pay", "transfer"], "ai_suggestions": []}'),
('Smart Subscription System', 'smart-subscription-system', 'Business', 'Subscription management', '{"framework": "react", "features": ["plans", "billing", "renewals"], "permissions": ["manage_subscriptions"], "actions": ["subscribe"], "ai_suggestions": ["recommend_plan"]}')
ON CONFLICT (slug) DO NOTHING;