-- Fix search_path for trigger function
DROP FUNCTION IF EXISTS public.update_affiliate_updated_at() CASCADE;

CREATE OR REPLACE FUNCTION public.update_affiliate_updated_at()
RETURNS TRIGGER
LANGUAGE plpgsql
SECURITY DEFINER
SET search_path = public
AS $$
BEGIN
  NEW.updated_at = now();
  RETURN NEW;
END;
$$;

-- Recreate triggers
CREATE TRIGGER update_affiliate_links_updated_at
  BEFORE UPDATE ON public.affiliate_links
  FOR EACH ROW
  EXECUTE FUNCTION public.update_affiliate_updated_at();

CREATE TRIGGER update_affiliate_settings_updated_at
  BEFORE UPDATE ON public.affiliate_settings
  FOR EACH ROW
  EXECUTE FUNCTION public.update_affiliate_updated_at();