-- Seed 50+ module templates with comprehensive configurations
INSERT INTO public.module_templates (name, slug, category, description, is_multi_tenant, template_config) VALUES

-- Business Modules (10)
('POS System', 'pos-system', 'Business', 'Complete Point of Sale system with inventory, billing, and reports', true, '{
  "framework": "laravel",
  "folders": ["app/Models", "app/Http/Controllers", "resources/views/pos", "database/migrations"],
  "files": {
    "app/Models/Product.php": "<?php namespace App\\Models; use Illuminate\\Database\\Eloquent\\Model; class Product extends Model { protected $fillable = [\"name\", \"sku\", \"price\", \"stock\", \"tenant_id\"]; }",
    "app/Http/Controllers/POSController.php": "<?php namespace App\\Http\\Controllers; class POSController extends Controller { public function index() { return view(\"pos.index\"); } }",
    "database/migrations/create_products_table.php": "<?php use Illuminate\\Database\\Migrations\\Migration; Schema::create(\"products\", function($table) { $table->id(); $table->string(\"name\"); $table->string(\"sku\"); $table->decimal(\"price\"); $table->integer(\"stock\"); $table->foreignId(\"tenant_id\"); $table->timestamps(); });"
  },
  "routes": ["/pos", "/pos/sale", "/pos/inventory"],
  "api_endpoints": ["/api/products", "/api/sales", "/api/inventory"],
  "ui_components": ["ProductList", "SaleForm", "InventoryDashboard"]
}'::jsonb),

('CRM System', 'crm-system', 'Business', 'Customer Relationship Management with leads, contacts, and sales pipeline', true, '{
  "framework": "laravel",
  "folders": ["app/Models", "app/Http/Controllers/CRM", "resources/views/crm"],
  "files": {
    "app/Models/Lead.php": "<?php namespace App\\Models; class Lead extends Model { protected $fillable = [\"name\", \"email\", \"phone\", \"status\", \"tenant_id\"]; }",
    "app/Http/Controllers/CRM/LeadController.php": "<?php namespace App\\Http\\Controllers\\CRM; class LeadController extends Controller { public function index() { return view(\"crm.leads\"); } }"
  },
  "routes": ["/crm", "/crm/leads", "/crm/contacts", "/crm/pipeline"],
  "api_endpoints": ["/api/leads", "/api/contacts", "/api/deals"]
}'::jsonb),

('Accounting System', 'accounting-system', 'Business', 'Complete accounting with invoices, expenses, and financial reports', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Accounting", "app/Http/Controllers/Accounting"],
  "files": {
    "app/Models/Accounting/Invoice.php": "<?php namespace App\\Models\\Accounting; class Invoice extends Model { protected $fillable = [\"invoice_number\", \"client_id\", \"amount\", \"due_date\", \"tenant_id\"]; }"
  },
  "routes": ["/accounting", "/accounting/invoices", "/accounting/expenses"],
  "api_endpoints": ["/api/invoices", "/api/expenses", "/api/reports"]
}'::jsonb),

('Inventory Management', 'inventory-management', 'Business', 'Warehouse and inventory tracking system with stock alerts', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Inventory", "app/Http/Controllers/Inventory"],
  "routes": ["/inventory", "/inventory/stock", "/inventory/warehouses"],
  "api_endpoints": ["/api/inventory/items", "/api/inventory/transfers", "/api/inventory/alerts"]
}'::jsonb),

('HR Management', 'hr-management', 'Business', 'Employee management with attendance, payroll, and leave tracking', true, '{
  "framework": "laravel",
  "folders": ["app/Models/HR", "app/Http/Controllers/HR"],
  "routes": ["/hr", "/hr/employees", "/hr/attendance", "/hr/payroll"],
  "api_endpoints": ["/api/employees", "/api/attendance", "/api/payroll", "/api/leave"]
}'::jsonb),

('Project Management', 'project-management', 'Business', 'Task and project tracking with team collaboration', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Project", "app/Http/Controllers/Project"],
  "routes": ["/projects", "/projects/tasks", "/projects/timeline"],
  "api_endpoints": ["/api/projects", "/api/tasks", "/api/milestones"]
}'::jsonb),

('E-commerce Store', 'ecommerce-store', 'Business', 'Online store with cart, checkout, and order management', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Shop", "app/Http/Controllers/Shop"],
  "routes": ["/shop", "/shop/products", "/shop/cart", "/shop/checkout"],
  "api_endpoints": ["/api/shop/products", "/api/cart", "/api/orders"]
}'::jsonb),

('Booking System', 'booking-system', 'Business', 'Appointment and reservation management system', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Booking", "app/Http/Controllers/Booking"],
  "routes": ["/bookings", "/bookings/calendar", "/bookings/services"],
  "api_endpoints": ["/api/bookings", "/api/availability", "/api/services"]
}'::jsonb),

('Restaurant POS', 'restaurant-pos', 'Business', 'Restaurant management with table booking, orders, and kitchen display', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Restaurant", "app/Http/Controllers/Restaurant"],
  "routes": ["/restaurant", "/restaurant/tables", "/restaurant/orders", "/restaurant/kitchen"],
  "api_endpoints": ["/api/tables", "/api/orders", "/api/menu", "/api/kitchen"]
}'::jsonb),

('Warehouse Management', 'warehouse-management', 'Business', 'Complete warehouse operations with picking, packing, and shipping', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Warehouse", "app/Http/Controllers/Warehouse"],
  "routes": ["/warehouse", "/warehouse/receiving", "/warehouse/picking", "/warehouse/shipping"],
  "api_endpoints": ["/api/warehouse/items", "/api/warehouse/orders", "/api/warehouse/shipments"]
}'::jsonb),

-- Medical Modules (8)
('Hospital Management', 'hospital-management', 'Medical', 'Complete hospital system with patients, doctors, and appointments', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Hospital", "app/Http/Controllers/Hospital"],
  "routes": ["/hospital", "/hospital/patients", "/hospital/doctors", "/hospital/appointments"],
  "api_endpoints": ["/api/patients", "/api/doctors", "/api/appointments", "/api/prescriptions"]
}'::jsonb),

('Pharmacy Management', 'pharmacy-management', 'Medical', 'Pharmacy system with medicine inventory and prescription tracking', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Pharmacy", "app/Http/Controllers/Pharmacy"],
  "routes": ["/pharmacy", "/pharmacy/medicines", "/pharmacy/prescriptions", "/pharmacy/sales"],
  "api_endpoints": ["/api/medicines", "/api/prescriptions", "/api/pharmacy-sales"]
}'::jsonb),

('Clinic Management', 'clinic-management', 'Medical', 'Clinic operations with patient records and billing', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Clinic", "app/Http/Controllers/Clinic"],
  "routes": ["/clinic", "/clinic/patients", "/clinic/visits", "/clinic/billing"],
  "api_endpoints": ["/api/clinic/patients", "/api/clinic/visits", "/api/clinic/billing"]
}'::jsonb),

('Lab Management', 'lab-management', 'Medical', 'Laboratory system with test management and results', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Lab", "app/Http/Controllers/Lab"],
  "routes": ["/lab", "/lab/tests", "/lab/samples", "/lab/results"],
  "api_endpoints": ["/api/lab/tests", "/api/lab/samples", "/api/lab/results"]
}'::jsonb),

('Telemedicine', 'telemedicine', 'Medical', 'Online consultation platform with video calls and prescriptions', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Telemedicine", "app/Http/Controllers/Telemedicine"],
  "routes": ["/telemedicine", "/telemedicine/consultations", "/telemedicine/video"],
  "api_endpoints": ["/api/consultations", "/api/video-calls", "/api/e-prescriptions"]
}'::jsonb),

('Medical Records', 'medical-records', 'Medical', 'Electronic Health Records (EHR) system', true, '{
  "framework": "laravel",
  "folders": ["app/Models/EHR", "app/Http/Controllers/EHR"],
  "routes": ["/ehr", "/ehr/records", "/ehr/history"],
  "api_endpoints": ["/api/ehr/records", "/api/ehr/history", "/api/ehr/documents"]
}'::jsonb),

('Dental Clinic', 'dental-clinic', 'Medical', 'Dental practice management with treatment plans', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Dental", "app/Http/Controllers/Dental"],
  "routes": ["/dental", "/dental/patients", "/dental/treatments"],
  "api_endpoints": ["/api/dental/patients", "/api/dental/treatments", "/api/dental/appointments"]
}'::jsonb),

('Diagnostic Center', 'diagnostic-center', 'Medical', 'Diagnostic center with imaging and reports', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Diagnostic", "app/Http/Controllers/Diagnostic"],
  "routes": ["/diagnostic", "/diagnostic/imaging", "/diagnostic/reports"],
  "api_endpoints": ["/api/diagnostic/tests", "/api/diagnostic/imaging", "/api/diagnostic/reports"]
}'::jsonb),

-- Salon & Spa Modules (5)
('Salon Management', 'salon-management', 'Salon', 'Beauty salon with appointments, services, and staff management', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Salon", "app/Http/Controllers/Salon"],
  "routes": ["/salon", "/salon/appointments", "/salon/services", "/salon/staff"],
  "api_endpoints": ["/api/salon/appointments", "/api/salon/services", "/api/salon/staff"]
}'::jsonb),

('Spa Management', 'spa-management', 'Salon', 'Spa center with packages, therapies, and bookings', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Spa", "app/Http/Controllers/Spa"],
  "routes": ["/spa", "/spa/packages", "/spa/therapies", "/spa/bookings"],
  "api_endpoints": ["/api/spa/packages", "/api/spa/therapies", "/api/spa/bookings"]
}'::jsonb),

('Barber Shop', 'barber-shop', 'Salon', 'Barbershop management with queuing system', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Barber", "app/Http/Controllers/Barber"],
  "routes": ["/barber", "/barber/queue", "/barber/services"],
  "api_endpoints": ["/api/barber/queue", "/api/barber/services", "/api/barber/bookings"]
}'::jsonb),

('Fitness Center', 'fitness-center', 'Salon', 'Gym management with memberships and trainers', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Gym", "app/Http/Controllers/Gym"],
  "routes": ["/gym", "/gym/members", "/gym/trainers", "/gym/classes"],
  "api_endpoints": ["/api/gym/members", "/api/gym/trainers", "/api/gym/classes"]
}'::jsonb),

('Yoga Studio', 'yoga-studio', 'Salon', 'Yoga studio with class scheduling and instructor management', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Yoga", "app/Http/Controllers/Yoga"],
  "routes": ["/yoga", "/yoga/classes", "/yoga/instructors"],
  "api_endpoints": ["/api/yoga/classes", "/api/yoga/instructors", "/api/yoga/bookings"]
}'::jsonb),

-- Legal Modules (5)
('Law Firm Management', 'law-firm-management', 'Lawyer', 'Law firm with case management and client tracking', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Legal", "app/Http/Controllers/Legal"],
  "routes": ["/legal", "/legal/cases", "/legal/clients", "/legal/documents"],
  "api_endpoints": ["/api/cases", "/api/legal-clients", "/api/legal-documents"]
}'::jsonb),

('Court Management', 'court-management', 'Lawyer', 'Court case tracking with hearing schedules', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Court", "app/Http/Controllers/Court"],
  "routes": ["/court", "/court/cases", "/court/hearings"],
  "api_endpoints": ["/api/court/cases", "/api/court/hearings", "/api/court/orders"]
}'::jsonb),

('Legal Document Generator', 'legal-document-generator', 'Lawyer', 'Automated legal document creation system', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Document", "app/Http/Controllers/Document"],
  "routes": ["/documents", "/documents/templates", "/documents/generate"],
  "api_endpoints": ["/api/document-templates", "/api/generate-document"]
}'::jsonb),

('Contract Management', 'contract-management', 'Lawyer', 'Contract lifecycle management system', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Contract", "app/Http/Controllers/Contract"],
  "routes": ["/contracts", "/contracts/drafts", "/contracts/active"],
  "api_endpoints": ["/api/contracts", "/api/contract-drafts", "/api/contract-signing"]
}'::jsonb),

('Legal Consultation', 'legal-consultation', 'Lawyer', 'Online legal consultation platform', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Consultation", "app/Http/Controllers/Consultation"],
  "routes": ["/consultation", "/consultation/booking", "/consultation/video"],
  "api_endpoints": ["/api/consultations", "/api/lawyers", "/api/consultation-video"]
}'::jsonb),

-- Education Modules (6)
('School Management', 'school-management', 'School', 'Complete school system with students, teachers, and classes', true, '{
  "framework": "laravel",
  "folders": ["app/Models/School", "app/Http/Controllers/School"],
  "routes": ["/school", "/school/students", "/school/teachers", "/school/classes"],
  "api_endpoints": ["/api/students", "/api/teachers", "/api/classes", "/api/attendance"]
}'::jsonb),

('LMS Platform', 'lms-platform', 'School', 'Learning Management System with courses and assessments', true, '{
  "framework": "laravel",
  "folders": ["app/Models/LMS", "app/Http/Controllers/LMS"],
  "routes": ["/lms", "/lms/courses", "/lms/lessons", "/lms/assessments"],
  "api_endpoints": ["/api/courses", "/api/lessons", "/api/assessments", "/api/enrollments"]
}'::jsonb),

('Exam Management', 'exam-management', 'School', 'Examination system with online tests and results', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Exam", "app/Http/Controllers/Exam"],
  "routes": ["/exams", "/exams/schedule", "/exams/results"],
  "api_endpoints": ["/api/exams", "/api/exam-schedule", "/api/results"]
}'::jsonb),

('Library Management', 'library-management', 'School', 'Library system with book issuing and returns', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Library", "app/Http/Controllers/Library"],
  "routes": ["/library", "/library/books", "/library/issued"],
  "api_endpoints": ["/api/books", "/api/issue-book", "/api/return-book"]
}'::jsonb),

('Coaching Center', 'coaching-center', 'School', 'Coaching institute with batch management', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Coaching", "app/Http/Controllers/Coaching"],
  "routes": ["/coaching", "/coaching/batches", "/coaching/students"],
  "api_endpoints": ["/api/batches", "/api/coaching-students", "/api/fees"]
}'::jsonb),

('Student Portal', 'student-portal', 'School', 'Student information system with grades and attendance', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Student", "app/Http/Controllers/Student"],
  "routes": ["/student", "/student/grades", "/student/attendance"],
  "api_endpoints": ["/api/student-info", "/api/grades", "/api/student-attendance"]
}'::jsonb),

-- E-commerce & Marketplace (6)
('Online Marketplace', 'online-marketplace', 'Bazar', 'Multi-vendor marketplace with seller management', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Marketplace", "app/Http/Controllers/Marketplace"],
  "routes": ["/marketplace", "/marketplace/vendors", "/marketplace/products"],
  "api_endpoints": ["/api/vendors", "/api/marketplace-products", "/api/vendor-orders"]
}'::jsonb),

('Grocery Store', 'grocery-store', 'Bazar', 'Online grocery shopping with delivery management', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Grocery", "app/Http/Controllers/Grocery"],
  "routes": ["/grocery", "/grocery/categories", "/grocery/cart"],
  "api_endpoints": ["/api/grocery-products", "/api/grocery-cart", "/api/delivery"]
}'::jsonb),

('Food Delivery', 'food-delivery', 'Bazar', 'Restaurant aggregator with order and delivery tracking', true, '{
  "framework": "laravel",
  "folders": ["app/Models/FoodDelivery", "app/Http/Controllers/FoodDelivery"],
  "routes": ["/food", "/food/restaurants", "/food/orders"],
  "api_endpoints": ["/api/restaurants", "/api/food-orders", "/api/delivery-tracking"]
}'::jsonb),

('Fashion Store', 'fashion-store', 'Bazar', 'Fashion e-commerce with size charts and wishlists', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Fashion", "app/Http/Controllers/Fashion"],
  "routes": ["/fashion", "/fashion/products", "/fashion/wishlist"],
  "api_endpoints": ["/api/fashion-products", "/api/wishlist", "/api/size-chart"]
}'::jsonb),

('Electronics Store', 'electronics-store', 'Bazar', 'Electronics shop with warranty tracking', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Electronics", "app/Http/Controllers/Electronics"],
  "routes": ["/electronics", "/electronics/products", "/electronics/warranty"],
  "api_endpoints": ["/api/electronics-products", "/api/warranty", "/api/electronics-orders"]
}'::jsonb),

('Book Store', 'book-store', 'Bazar', 'Online bookstore with author and genre filtering', true, '{
  "framework": "laravel",
  "folders": ["app/Models/BookStore", "app/Http/Controllers/BookStore"],
  "routes": ["/bookstore", "/bookstore/books", "/bookstore/authors"],
  "api_endpoints": ["/api/books", "/api/authors", "/api/book-orders"]
}'::jsonb),

-- Design & Creative (5)
('Portfolio Builder', 'portfolio-builder', 'Design', 'Portfolio website builder for creatives', false, '{
  "framework": "react",
  "folders": ["src/components/Portfolio", "src/pages/Portfolio"],
  "routes": ["/portfolio", "/portfolio/projects", "/portfolio/about"],
  "api_endpoints": ["/api/portfolio/projects", "/api/portfolio/contact"]
}'::jsonb),

('Website Builder', 'website-builder', 'Design', 'Drag-and-drop website builder', false, '{
  "framework": "react",
  "folders": ["src/components/Builder", "src/pages/Builder"],
  "routes": ["/builder", "/builder/editor", "/builder/preview"],
  "api_endpoints": ["/api/builder/save", "/api/builder/publish"]
}'::jsonb),

('Logo Maker', 'logo-maker', 'Design', 'AI-powered logo design tool', false, '{
  "framework": "react",
  "folders": ["src/components/LogoMaker", "src/pages/LogoMaker"],
  "routes": ["/logo-maker", "/logo-maker/create", "/logo-maker/download"],
  "api_endpoints": ["/api/logo/generate", "/api/logo/save"]
}'::jsonb),

('Graphic Design Studio', 'graphic-design-studio', 'Design', 'Online graphic design tool', false, '{
  "framework": "react",
  "folders": ["src/components/DesignStudio", "src/pages/DesignStudio"],
  "routes": ["/design-studio", "/design-studio/editor", "/design-studio/templates"],
  "api_endpoints": ["/api/design/templates", "/api/design/save"]
}'::jsonb),

('Print Shop', 'print-shop', 'Design', 'Custom printing service management', true, '{
  "framework": "laravel",
  "folders": ["app/Models/Print", "app/Http/Controllers/Print"],
  "routes": ["/print", "/print/orders", "/print/designs"],
  "api_endpoints": ["/api/print/orders", "/api/print/upload", "/api/print/pricing"]
}'::jsonb),

-- AI Tools (5)
('AI Chatbot Builder', 'ai-chatbot-builder', 'AI Tools', 'Build custom AI chatbots', false, '{
  "framework": "react",
  "folders": ["src/components/ChatbotBuilder", "src/pages/ChatbotBuilder"],
  "routes": ["/chatbot-builder", "/chatbot-builder/train", "/chatbot-builder/deploy"],
  "api_endpoints": ["/api/chatbot/create", "/api/chatbot/train", "/api/chatbot/messages"]
}'::jsonb),

('AI Content Generator', 'ai-content-generator', 'AI Tools', 'AI-powered content creation tool', false, '{
  "framework": "react",
  "folders": ["src/components/ContentGenerator", "src/pages/ContentGenerator"],
  "routes": ["/content-generator", "/content-generator/create"],
  "api_endpoints": ["/api/content/generate", "/api/content/save"]
}'::jsonb),

('AI Image Generator', 'ai-image-generator', 'AI Tools', 'Text-to-image generation platform', false, '{
  "framework": "react",
  "folders": ["src/components/ImageGenerator", "src/pages/ImageGenerator"],
  "routes": ["/image-generator", "/image-generator/create"],
  "api_endpoints": ["/api/image/generate", "/api/image/save"]
}'::jsonb),

('AI Voice Assistant', 'ai-voice-assistant', 'AI Tools', 'Voice-enabled AI assistant', false, '{
  "framework": "react",
  "folders": ["src/components/VoiceAssistant", "src/pages/VoiceAssistant"],
  "routes": ["/voice-assistant", "/voice-assistant/settings"],
  "api_endpoints": ["/api/voice/transcribe", "/api/voice/respond"]
}'::jsonb),

('AI Code Assistant', 'ai-code-assistant', 'AI Tools', 'AI-powered coding helper', false, '{
  "framework": "react",
  "folders": ["src/components/CodeAssistant", "src/pages/CodeAssistant"],
  "routes": ["/code-assistant", "/code-assistant/editor"],
  "api_endpoints": ["/api/code/generate", "/api/code/explain", "/api/code/debug"]
}'::jsonb)

ON CONFLICT (slug) DO UPDATE SET
  name = EXCLUDED.name,
  category = EXCLUDED.category,
  description = EXCLUDED.description,
  is_multi_tenant = EXCLUDED.is_multi_tenant,
  template_config = EXCLUDED.template_config,
  updated_at = now();