-- Create seba_modules table for Smart Seba HQ website
CREATE TABLE public.seba_modules (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  slug TEXT UNIQUE NOT NULL,
  name TEXT NOT NULL,
  name_bn TEXT,
  short_tagline TEXT,
  short_tagline_bn TEXT,
  category TEXT NOT NULL,
  icon TEXT DEFAULT '📦',
  is_visible_public BOOLEAN DEFAULT true,
  is_public_unlocked BOOLEAN DEFAULT false,
  progress_percent INTEGER DEFAULT 0 CHECK (progress_percent >= 0 AND progress_percent <= 100),
  status TEXT DEFAULT 'planned' CHECK (status IN ('planned', 'in-progress', 'live', 'paused')),
  overview TEXT,
  overview_bn TEXT,
  key_features TEXT,
  key_features_bn TEXT,
  business_model TEXT,
  target_users TEXT,
  notes_internal TEXT,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT now()
);

-- Enable RLS
ALTER TABLE public.seba_modules ENABLE ROW LEVEL SECURITY;

-- Public can view visible modules
CREATE POLICY "Anyone can view visible seba modules"
ON public.seba_modules
FOR SELECT
USING (is_visible_public = true);

-- Owner can view all modules
CREATE POLICY "Owner can view all seba modules"
ON public.seba_modules
FOR SELECT
USING (is_core_brain_owner());

-- Owner can manage modules
CREATE POLICY "Owner can insert seba modules"
ON public.seba_modules
FOR INSERT
WITH CHECK (is_core_brain_owner());

CREATE POLICY "Owner can update seba modules"
ON public.seba_modules
FOR UPDATE
USING (is_core_brain_owner());

CREATE POLICY "Owner can delete seba modules"
ON public.seba_modules
FOR DELETE
USING (is_core_brain_owner());

-- Trigger to update updated_at
CREATE TRIGGER update_seba_modules_updated_at
BEFORE UPDATE ON public.seba_modules
FOR EACH ROW
EXECUTE FUNCTION public.update_updated_at();

-- Seed initial modules
INSERT INTO public.seba_modules (slug, name, name_bn, category, icon, short_tagline, short_tagline_bn, status, progress_percent, is_public_unlocked, overview, key_features, business_model, target_users) VALUES
('smart-friend-core', 'Smart Friend (Core Brain)', 'স্মার্ট ফ্রেন্ড (কোর ব্রেইন)', 'Core', '🤖', 'AI super assistant for all Smart Seba modules', 'সকল স্মার্ট সেবা মডিউলের জন্য AI সুপার অ্যাসিস্ট্যান্ট', 'live', 95, true, 'Smart Friend is the central AI brain powering the entire Smart Seba ecosystem. It provides intelligent assistance, multi-language support, offline capabilities, and integrates with all other modules seamlessly.', E'✓ Multi-language AI chat (100+ languages)\n✓ Voice input/output\n✓ Offline mode with local brain\n✓ Identity-aware responses\n✓ Safety filtering\n✓ Memory system\n✓ Function calling capabilities', 'Freemium model with premium features for power users and enterprises', 'General users, students, professionals, businesses'),

('smart-friend-ava', 'Smart Friend 2 – AVA Child Mode', 'স্মার্ট ফ্রেন্ড ২ – AVA চাইল্ড মোড', 'Child Safety / Education', '👶', 'Child-safe AI OS for Ava and kids', 'শিশুদের জন্য নিরাপদ AI অপারেটিং সিস্টেম', 'in-progress', 85, true, 'AVA is a child-safe AI operating system designed specifically for kids. It features strict content filtering, parental controls, educational content, and a safe environment for children to learn and explore.', E'✓ Strict content filtering\n✓ Age-appropriate responses\n✓ Parental dashboard and controls\n✓ Educational games and activities\n✓ No ads or inappropriate content\n✓ Voice-based interaction\n✓ Progress tracking', 'Subscription-based for families with special features for schools', 'Children (3-12 years), Parents, Schools'),

('smart-academy', 'Smart Academy + Online Exam', 'স্মার্ট একাডেমি', 'Education', '🎓', 'Complete educational platform with AI-powered exams', 'AI চালিত পরীক্ষা সহ সম্পূর্ণ শিক্ষা প্ল্যাটফর্ম', 'live', 90, true, 'Smart Academy is a comprehensive educational platform offering courses, online exams, AI-powered evaluation, and personalized learning paths for students of all levels.', E'✓ Interactive courses and chapters\n✓ AI-powered exam system\n✓ Automated grading and feedback\n✓ Video lectures\n✓ Progress tracking\n✓ Certificates\n✓ Live classes integration', 'Subscription for students, licensing for schools and coaching centers', 'Students, Teachers, Educational institutions'),

('smart-marketer', 'Smart Marketer', 'স্মার্ট মার্কেটার', 'Business / Marketing', '📊', 'AI-powered marketing automation and analytics', 'AI চালিত মার্কেটিং অটোমেশন এবং বিশ্লেষণ', 'in-progress', 70, false, 'Smart Marketer provides AI-powered marketing tools including campaign management, social media automation, content generation, and analytics.', E'✓ Campaign planning and execution\n✓ Social media automation\n✓ AI content generation\n✓ Analytics dashboard\n✓ Multi-platform support\n✓ A/B testing\n✓ ROI tracking', 'SaaS subscription with tiered pricing based on features and scale', 'Marketers, Small businesses, Agencies'),

('smart-design-hub', 'Smart Design Hub', 'স্মার্ট ডিজাইন হাব', 'Design / Media', '🎨', 'Professional design tools and AI assistance', 'পেশাদার ডিজাইন টুলস এবং AI সহায়তা', 'live', 80, true, 'Smart Design Hub offers professional design tools with AI assistance for creating graphics, videos, presentations, and marketing materials.', E'✓ Graphic design tools\n✓ AI-powered templates\n✓ Brand kit management\n✓ Collaboration features\n✓ Export in multiple formats\n✓ Stock assets library\n✓ Video editing capabilities', 'Freemium with premium templates and features', 'Designers, Content creators, Businesses'),

('smart-hospital', 'Smart Hospital', 'স্মার্ট হাসপাতাল', 'Health', '🏥', 'Complete hospital management system', 'সম্পূর্ণ হাসপাতাল ব্যবস্থাপনা সিস্টেম', 'in-progress', 75, false, 'Smart Hospital is a comprehensive hospital management system covering patient records, appointments, billing, inventory, and staff management.', E'✓ Patient management\n✓ Appointment scheduling\n✓ Electronic health records\n✓ Billing and insurance\n✓ Inventory management\n✓ Staff scheduling\n✓ Reporting and analytics', 'Licensed software for hospitals with per-bed pricing', 'Hospitals, Clinics, Healthcare providers'),

('smart-doctor', 'Smart Doctor (AI Doctor)', 'স্মার্ট ডাক্তার', 'Health / AI', '⚕️', 'AI-powered medical consultation and diagnosis', 'AI চালিত মেডিকেল পরামর্শ এবং রোগ নির্ণয়', 'live', 85, true, 'Smart Doctor provides AI-powered preliminary medical consultation, symptom analysis, and health guidance. Not a replacement for real doctors but a helpful first step.', E'✓ Symptom checker\n✓ AI-powered diagnosis suggestions\n✓ Medication information\n✓ Doctor recommendations\n✓ Health tips and guidance\n✓ Emergency protocols\n✓ Medical history tracking', 'Freemium with premium AI consultations', 'General public, Patients'),

('smart-news', 'Smart News', 'স্মার্ট নিউজ', 'News / Media', '📰', 'AI-curated news with fact-checking', 'ফ্যাক্ট চেকিং সহ AI কিউরেটেড নিউজ', 'live', 80, true, 'Smart News delivers personalized, fact-checked news from multiple sources with AI-powered summarization and fake news detection.', E'✓ Personalized news feed\n✓ Fact-checking system\n✓ Multiple categories\n✓ AI summaries\n✓ Multi-language support\n✓ Breaking news alerts\n✓ Source credibility ratings', 'Ad-supported with premium ad-free experience', 'General public, Journalists'),

('smart-pay', 'Smart Pay (Wallet + Payments)', 'স্মার্ট পে', 'Payments', '💳', 'Secure digital wallet and payment gateway', 'নিরাপদ ডিজিটাল ওয়ালেট এবং পেমেন্ট গেটওয়ে', 'live', 88, true, 'Smart Pay is a comprehensive digital payment solution with wallet, money transfers, bill payments, and payment gateway services.', E'✓ Digital wallet\n✓ P2P transfers\n✓ Bill payments\n✓ Payment gateway API\n✓ QR code payments\n✓ Transaction history\n✓ Multi-currency support', 'Transaction fees and merchant services', 'Individuals, Merchants, Businesses'),

('smart-fnf', 'Smart FNF (Facebook Alternative)', 'স্মার্ট এফএনএফ', 'Social', '👥', 'Privacy-first social networking platform', 'গোপনীয়তা প্রথম সামাজিক নেটওয়ার্কিং প্ল্যাটফর্ম', 'planned', 20, false, 'Smart FNF (Friends and Family) is a privacy-focused social networking platform emphasizing genuine connections and data ownership.', E'✓ Privacy-first design\n✓ No data selling\n✓ Groups and communities\n✓ Content sharing\n✓ Messaging\n✓ Events\n✓ User data ownership', 'Freemium with optional premium features', 'Social media users seeking privacy'),

('smart-tourist', 'Smart Tourist', 'স্মার্ট ট্যুরিস্ট', 'Travel', '🗺️', 'Travel planning and booking platform', 'ভ্রমণ পরিকল্পনা এবং বুকিং প্ল্যাটফর্ম', 'live', 75, true, 'Smart Tourist helps plan trips, book hotels and tour packages, and discover tourist destinations with AI-powered recommendations.', E'✓ Destination guides\n✓ Hotel booking\n✓ Tour packages\n✓ AI itinerary planning\n✓ Reviews and ratings\n✓ Price comparison\n✓ Travel tips', 'Commission on bookings and premium listings', 'Travelers, Tour operators, Hotels'),

('smart-bazar', 'Smart Bazar (Marketplace)', 'স্মার্ট বাজার', 'Commerce', '🛒', 'Multi-tenant e-commerce marketplace', 'মাল্টি-টেন্যান্ট ই-কমার্স মার্কেটপ্লেস', 'live', 82, true, 'Smart Bazar is a multi-vendor e-commerce marketplace where businesses can set up their own stores and sell products online.', E'✓ Multi-vendor marketplace\n✓ Merchant dashboards\n✓ Product management\n✓ Order processing\n✓ Payment integration\n✓ Delivery tracking\n✓ Reviews and ratings', 'Commission on sales and premium merchant features', 'Merchants, Shoppers, Small businesses'),

('smart-lawyer', 'Smart Lawyer', 'স্মার্ট আইনজীবী', 'Legal', '⚖️', 'AI-powered legal consultation and documentation', 'AI চালিত আইনি পরামর্শ এবং ডকুমেন্টেশন', 'live', 78, true, 'Smart Lawyer provides AI-powered legal guidance, document templates, lawyer matching, and case management for common legal needs.', E'✓ Legal consultation AI\n✓ Document templates\n✓ Lawyer directory\n✓ Case management\n✓ Legal resources\n✓ Contract review\n✓ Legal advice', 'Pay-per-consultation and lawyer subscriptions', 'General public, Law firms, Lawyers'),

('smart-hisab', 'Smart Hisab (Accounting)', 'স্মার্ট হিসাব', 'Finance', '💰', 'Automated accounting and financial management', 'স্বয়ংক্রিয় হিসাব এবং আর্থিক ব্যবস্থাপনা', 'in-progress', 60, false, 'Smart Hisab automates bookkeeping, invoicing, expense tracking, and financial reporting for small businesses.', E'✓ Automated bookkeeping\n✓ Invoice generation\n✓ Expense tracking\n✓ Financial reports\n✓ Tax calculations\n✓ Bank integration\n✓ Multi-currency support', 'Subscription-based with tiered pricing', 'Small businesses, Freelancers, Accountants'),

('smart-ai-ad', 'Smart AI Ad Firm', 'স্মার্ট AI বিজ্ঞাপন', 'Marketing / Media', '📺', 'AI-generated video ads and campaigns', 'AI জেনারেটেড ভিডিও বিজ্ঞাপন এবং ক্যাম্পেইন', 'live', 85, true, 'Smart AI Ad Firm creates professional video advertisements using AI, from concept to final video with voiceovers and effects.', E'✓ AI script writing\n✓ Automated video generation\n✓ Voiceover synthesis\n✓ Storyboard creation\n✓ Multiple export formats\n✓ Brand consistency\n✓ Quick turnaround', 'Pay-per-video and agency subscriptions', 'Businesses, Marketing agencies, Content creators'),

('smart-streaming', 'Smart Streaming (Netflix-style)', 'স্মার্ট স্ট্রিমিং', 'Media / Entertainment', '🎬', 'Video streaming platform with AI recommendations', 'AI সুপারিশ সহ ভিডিও স্ট্রিমিং প্ল্যাটফর্ম', 'planned', 30, false, 'Smart Streaming is a video-on-demand platform with AI-powered content recommendations, original content, and subscription management.', E'✓ Video streaming\n✓ AI recommendations\n✓ Multiple quality options\n✓ Offline downloads\n✓ Parental controls\n✓ Multi-device support\n✓ Content creator platform', 'Subscription-based with content creator revenue sharing', 'Content consumers, Content creators'),

('smart-municipality', 'Smart Municipality & Union', 'স্মার্ট পৌরসভা ও ইউনিয়ন', 'Gov / Civic', '🏛️', 'Digital governance and civic services', 'ডিজিটাল গভর্নেন্স এবং নাগরিক সেবা', 'planned', 15, false, 'Smart Municipality digitizes local government services including tax collection, birth/death certificates, and citizen services.', E'✓ Digital tax collection\n✓ Certificate issuance\n✓ Complaint management\n✓ Public notices\n✓ Citizen portal\n✓ Service tracking\n✓ Transparency tools', 'Government licensing and implementation fees', 'Local governments, Citizens'),

('smart-desk', 'Smart Desk (Remote Support)', 'স্মার্ট ডেস্ক', 'Remote Support', '🖥️', 'Secure remote desktop support', 'নিরাপদ রিমোট ডেস্কটপ সাপোর্ট', 'planned', 25, false, 'Smart Desk provides secure remote desktop access for technical support with view-only mode and session logging.', E'✓ Remote screen sharing\n✓ View-only mode\n✓ Session recording\n✓ No file transfer\n✓ Secure connection\n✓ Cross-platform\n✓ Permission controls', 'Per-session fees and business subscriptions', 'IT support teams, Technical service providers'),

('smart-farming', 'Smart Farming Helper', 'স্মার্ট কৃষি সহায়ক', 'Agriculture', '🌾', 'AI assistant for farmers', 'কৃষকদের জন্য AI সহায়ক', 'in-progress', 55, false, 'Smart Farming Helper provides farmers with AI guidance on crops, weather, pest control, and market prices in their local language.', E'✓ Crop recommendations\n✓ Weather forecasts\n✓ Pest identification\n✓ Market prices\n✓ Farming calendar\n✓ Government schemes info\n✓ Voice-based in local languages', 'Freemium with premium expert consultations', 'Farmers, Agricultural workers'),

('fake-news-detector', 'Fake News Detector', 'ফেক নিউজ ডিটেক্টর', 'News / Safety', '🔍', 'AI-powered fake news detection', 'AI চালিত ভুয়া খবর সনাক্তকরণ', 'in-progress', 65, false, 'Fake News Detector uses AI to verify news authenticity, check sources, and provide credibility ratings for shared content.', E'✓ Real-time fact checking\n✓ Source verification\n✓ Credibility scoring\n✓ Browser extension\n✓ Social media integration\n✓ Report submission\n✓ Educational content', 'Free with optional API access for media organizations', 'General public, Journalists, Media organizations'),

('women-sos', 'Women Emergency SOS', 'মহিলা জরুরি SOS', 'Safety', '🚨', 'Emergency alert system for women', 'মহিলা সুরক্ষার জন্য জরুরি সতর্কতা', 'in-progress', 70, false, 'Women SOS provides one-touch emergency alerts with location sharing to trusted contacts and emergency services.', E'✓ One-touch SOS button\n✓ Live location sharing\n✓ Trusted contacts network\n✓ Audio/video recording\n✓ Emergency services integration\n✓ Fake call feature\n✓ Safety tips', 'Free public service with government partnerships', 'Women, Safety-conscious individuals'),

('bulk-sms', 'Bulk SMS Panel', 'বাল্ক এসএমএস প্যানেল', 'Communication', '📱', 'Mass SMS sending platform', 'গণ এসএমএস পাঠানো প্ল্যাটফর্ম', 'live', 90, false, 'Bulk SMS Panel enables businesses to send promotional and transactional SMS at scale with API integration.', E'✓ Mass SMS sending\n✓ Contact management\n✓ Campaign scheduling\n✓ Delivery reports\n✓ API integration\n✓ Template management\n✓ Analytics dashboard', 'Pay-per-SMS with volume discounts', 'Businesses, Marketing teams, Organizations'),

('smart-salon', 'Smart Salon', 'স্মার্ট সেলুন', 'Salon', '💇', 'Salon management system', 'সেলুন ব্যবস্থাপনা সিস্টেম', 'in-progress', 50, false, 'Smart Salon helps hair salons manage appointments, staff, inventory, and customer relationships efficiently.', E'✓ Appointment booking\n✓ Staff management\n✓ Inventory tracking\n✓ Customer database\n✓ Billing and payments\n✓ SMS reminders\n✓ Analytics', 'Monthly subscription per salon location', 'Hair salons, Barber shops'),

('smart-parlour', 'Smart Parlour (Beauty)', 'স্মার্ট পার্লার', 'Salon / Beauty', '💄', 'Beauty parlour management with virtual try-on', 'ভার্চুয়াল ট্রাই-অন সহ পার্লার ব্যবস্থাপনা', 'in-progress', 45, false, 'Smart Parlour offers beauty parlour management with AR-based virtual makeup try-on and customer engagement tools.', E'✓ Virtual makeup try-on\n✓ Appointment management\n✓ Service packages\n✓ Customer gallery\n✓ Product sales\n✓ Staff performance\n✓ Marketing tools', 'Subscription with AR features premium', 'Beauty parlours, Makeup artists'),

('smart-job', 'Smart Job', 'স্মার্ট জব', 'Jobs / HR', '💼', 'AI-powered job matching platform', 'AI চালিত চাকরি ম্যাচিং প্ল্যাটফর্ম', 'live', 80, true, 'Smart Job uses AI to match candidates with jobs based on skills, experience, and preferences, helping both job seekers and employers.', E'✓ AI-powered job matching\n✓ CV builder and analysis\n✓ Application tracking\n✓ Employer dashboard\n✓ Interview scheduling\n✓ Skill assessments\n✓ Career guidance', 'Freemium for job seekers, employer subscriptions', 'Job seekers, Employers, HR teams'),

('smart-call-center', 'Smart Call Center', 'স্মার্ট কল সেন্টার', 'Communication / Business', '☎️', 'AI-powered call center solution', 'AI চালিত কল সেন্টার', 'in-progress', 68, false, 'Smart Call Center provides AI-assisted customer support with ticket management, call routing, and analytics.', E'✓ Intelligent call routing\n✓ Ticket management\n✓ AI call transcription\n✓ Agent dashboard\n✓ Call analytics\n✓ CRM integration\n✓ Quality monitoring', 'Per-agent subscription with call volume pricing', 'Businesses, Customer support teams'),

('smart-school-erp', 'Smart School ERP', 'স্মার্ট স্কুল ERP', 'Education / Management', '🏫', 'Complete school management system', 'সম্পূর্ণ স্কুল ব্যবস্থাপনা', 'in-progress', 72, false, 'Smart School ERP manages all school operations including student records, attendance, exams, fees, and parent communication.', E'✓ Student information system\n✓ Attendance management\n✓ Exam and grading\n✓ Fee collection\n✓ Timetable management\n✓ Parent portal\n✓ Reports and analytics', 'Annual licensing per school with per-student pricing', 'Schools, Educational institutions');