-- Create seba_leads table for investor demo requests
CREATE TABLE IF NOT EXISTS public.seba_leads (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  module_id UUID REFERENCES public.seba_modules(id) ON DELETE CASCADE,
  name TEXT NOT NULL,
  email TEXT NOT NULL,
  phone TEXT,
  company TEXT,
  country TEXT,
  message TEXT,
  created_at TIMESTAMPTZ DEFAULT now()
);

-- Enable RLS
ALTER TABLE public.seba_leads ENABLE ROW LEVEL SECURITY;

-- Public can insert (no auth required for demo requests)
CREATE POLICY "Anyone can submit demo requests"
  ON public.seba_leads
  FOR INSERT
  TO anon, authenticated
  WITH CHECK (true);

-- Only owner can view leads
CREATE POLICY "Owner can view all leads"
  ON public.seba_leads
  FOR SELECT
  TO authenticated
  USING (
    EXISTS (
      SELECT 1 FROM auth.users
      WHERE auth.users.id = auth.uid()
      AND auth.users.email IN ('nazrul.tasnim24@gmail.com', 'engineer.tasnim@smartseba.com')
    )
  );

-- Create index for better query performance
CREATE INDEX IF NOT EXISTS idx_seba_leads_module_id ON public.seba_leads(module_id);
CREATE INDEX IF NOT EXISTS idx_seba_leads_created_at ON public.seba_leads(created_at DESC);