-- ================================================
-- CRITICAL SECURITY FIXES - Phase 1
-- ================================================

-- 1. DROP CRITICAL BACKDOOR: Remove Core Brain owner access to all profiles
DROP POLICY IF EXISTS "Core Brain owners can view other owners' profiles" ON public.profiles;

-- 2. FIX NEWS ARTICLES: Split the ALL policy into specific operations with proper checks
DROP POLICY IF EXISTS "Authors can manage own articles" ON public.news_articles;

CREATE POLICY "Authors can create own articles" 
ON public.news_articles FOR INSERT 
WITH CHECK (auth.uid() = author_id);

CREATE POLICY "Authors can update own articles" 
ON public.news_articles FOR UPDATE 
USING (auth.uid() = author_id);

CREATE POLICY "Authors can delete own articles" 
ON public.news_articles FOR DELETE 
USING (auth.uid() = author_id);

-- 3. RESTRICT MODULE TEMPLATES: Require authentication
DROP POLICY IF EXISTS "Anyone can view module templates" ON public.module_templates;

CREATE POLICY "Authenticated users can view templates" 
ON public.module_templates FOR SELECT 
USING (auth.uid() IS NOT NULL);

-- 4. PROTECT IDENTITY RULES: Core Brain owners only (if not already protected)
DROP POLICY IF EXISTS "Anyone can view identity rules" ON public.identity_rules;

CREATE POLICY "Core Brain owners can view identity rules" 
ON public.identity_rules FOR SELECT 
USING (public.is_core_brain_owner());

-- 5. PROTECT SAFETY FILTERS: Core Brain owners only  
DROP POLICY IF EXISTS "Anyone can view safety filters" ON public.safety_filter;

CREATE POLICY "Core Brain owners can view safety filters" 
ON public.safety_filter FOR SELECT 
USING (public.is_core_brain_owner());

CREATE POLICY "Core Brain owners can manage safety filters" 
ON public.safety_filter FOR ALL 
USING (public.is_core_brain_owner());