-- Create dev_brain_logs table for tracking all dev brain actions
CREATE TABLE IF NOT EXISTS public.dev_brain_logs (
  id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
  created_at TIMESTAMPTZ NOT NULL DEFAULT NOW(),
  user_id UUID NOT NULL REFERENCES auth.users(id) ON DELETE CASCADE,
  action_type TEXT NOT NULL,
  file_path TEXT,
  description TEXT NOT NULL,
  diff_content TEXT,
  status TEXT NOT NULL DEFAULT 'pending',
  metadata JSONB,
  applied_at TIMESTAMPTZ
);

-- Enable RLS
ALTER TABLE public.dev_brain_logs ENABLE ROW LEVEL SECURITY;

-- Policy: Only owner can view logs
CREATE POLICY "Only owner can view dev brain logs"
ON public.dev_brain_logs
FOR SELECT
TO authenticated
USING (
  EXISTS (
    SELECT 1 FROM public.user_roles
    WHERE user_id = auth.uid() AND role = 'owner'
  )
);

-- Policy: Only owner can insert logs
CREATE POLICY "Only owner can create dev brain logs"
ON public.dev_brain_logs
FOR INSERT
TO authenticated
WITH CHECK (
  EXISTS (
    SELECT 1 FROM public.user_roles
    WHERE user_id = auth.uid() AND role = 'owner'
  )
);

-- Policy: Only owner can update logs
CREATE POLICY "Only owner can update dev brain logs"
ON public.dev_brain_logs
FOR UPDATE
TO authenticated
USING (
  EXISTS (
    SELECT 1 FROM public.user_roles
    WHERE user_id = auth.uid() AND role = 'owner'
  )
);

-- Create index for faster queries
CREATE INDEX idx_dev_brain_logs_user_id ON public.dev_brain_logs(user_id);
CREATE INDEX idx_dev_brain_logs_created_at ON public.dev_brain_logs(created_at DESC);